//units are in meters

//get some colors
#include "colors.inc"

//it takes the moon 8 planet days to circle the planet, and the planet 4 months to circle the sun
//we're going to make one clock cycle be one month
#declare planetMonth = 1;
#declare planetDay = planetMonth*8;
#declare planetYear = planetMonth/4;

// place all settings of globally influenced features here
global_settings {
	ambient_light Yellow
}

//one light source
light_source {
	<20, 35, -2>
	color White
}

//camera is at eye-level
camera {
	location  <0, 2, -10>
	look_at   <0, 0, 0>

	right x*image_width/image_height
}

//the center of the universe
sphere {
	<0, 0, 0>
	2
	pigment {
		bozo
		color_map {
			[0.00 White]
			[0.45 SkyBlue]
			[0.55 SkyBlue]
			[0.70 White]
			[1.00 White]
		}
		warp {
			turbulence .5
		}
	}
	
	#if (clock_on)
		rotate <0, 360*clock*planetDay, 27>
	#end
}

//ring around the sphere
difference {
	cylinder {
		<0, -.01, 0>, <0, .01, 0>, 1
	
	}

	cylinder {
		<0, -.02, 0>, <0, .02, 0>, .8
	}
	
	pigment {
		cylindrical
		frequency 8
		color_map {
			[0.00 Magenta filter .5]
			[0.30 Yellow filter .5]
			[0.45 Green filter .5]
			[0.60 Cyan filter .5]
			[1.00 Magenta filter .5]
		}
	}

	scale <3.2, 1, 3.2>
	
	#if (clock_on)
		rotate <0, 360*planetMonth, 30>
	#else
		rotate <0, 0, 30>
	#end
}

//the moon
sphere {
	<6, 0, 0>
	.4
	pigment {
		color Grey
	}
	normal {
		bumps 1.5
		scale .1
	}
	#if (clock_on)
		rotate <0, 360*planetMonth, 27>
	#else
		rotate <0, 200, 27>
	#end
}


sky_sphere {
	pigment {
		bozo
		color_map {
			[0.00 White*3]
			[0.20 Black]
			[1.00 Black]
		}
		scale .006
	}
	
	#if (clock_on)
		rotate <0, 360*clock*planetYear, 0>
	#end
}
